cap log close
drop _all
log using "C:\Dropbox\hrs\wealthcouples\ADL\adl_log.log", replace

use C:\Dropbox\hrs\wealthcouples\dataprep2_4states, clear
***********************************************************
**** Produce information on the joint distribution of  ****
*************** Base and new health statuses **************
***********************************************************

tab womanhealadl womanheal
tab womanhealadl womanheal, mi

tab manhealadl manheal
tab manhealadl manheal, mi


***********************************************************
*** Produce information on medical expenseses with the ****
*************** Base and new health statuses **************
***********************************************************


*singles
sum hhmedcost if  womanheal>1 & womanheal!=. & hhstatus!=3, d
sum hhmedcost if  womanhealadl>1 & womanheal!=. & hhstatus!=3, d

sum hhmedcost if  womanheal==1 & womanheal!=. & hhstatus!=3, d
sum hhmedcost if  womanhealadl==1 & womanheal!=. & hhstatus!=3, d


sum hhmedcost if  manheal>1 & manheal!=. & hhstatus!=3, d
sum hhmedcost if  manhealadl>1 & manheal!=. & hhstatus!=3, d

sum hhmedcost if  manheal==1 & manheal!=. & hhstatus!=3, d
sum hhmedcost if  manhealadl==1 & manheal!=. & hhstatus!=3, d

sum hhmedcost if  womanheal==2 & hhstatus!=3

local bad=round(r(mean),10)

sum hhmedcost if  womanhealadl==2 & hhstatus!=3

local adl_adl=round(r(mean),10)

sum hhmedcost if  womanhealadl==3 & hhstatus!=3

local bad_adl=round(r(mean),10)

sum hhmedcost if  womanheal==1 & hhstatus!=3

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  womanheal==2 & hhstatus!=3 & hhmedcost<40000, lcolor(blue))  ( kdensity hhmedcost if  womanhealadl==3 & hhstatus!=3 & hhmedcost<40000,  lcolor(red)), legend(label(1 "Bad (Base)") label(2 "Bad (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `bad_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Swoman_badbothvsadl.pdf", replace

twoway ( kdensity hhmedcost if  womanheal==2 & hhstatus!=3 & hhmedcost<40000,  lcolor(blue))  ( kdensity hhmedcost if  womanhealadl==2 & hhstatus!=3 & hhmedcost<40000,  lcolor(red)), legend(label(1 "Bad (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Swoman_badvsadl.pdf", replace

twoway ( kdensity hhmedcost if  womanheal==1 & hhstatus!=3 & hhmedcost<110000,  lcolor(blue))  ( kdensity hhmedcost if womanhealadl==2 & hhstatus!=3 & hhmedcost<110000, lcolor(red)), legend(label(1 "NH (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 50000 "Mean: `NH'", color(blue)) text(0.000075 50000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Swoman_NHvsadl.pdf", replace

*men
sum hhmedcost if  manheal==2 & hhstatus!=3

local bad=round(r(mean),10)

sum hhmedcost if  manhealadl==2 & hhstatus!=3

local adl_adl=round(r(mean),10)

sum hhmedcost if  manhealadl==3 & hhstatus!=3

local bad_adl=round(r(mean),10)

sum hhmedcost if  manheal==1 & hhstatus!=3

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  manheal==2 & hhstatus!=3 & hhmedcost<40000, lcolor(blue))  ( kdensity hhmedcost if  manhealadl==3 & hhstatus!=3 & hhmedcost<40000, lcolor(red)), legend(label(1 "Bad (Base)") label(2 "Bad (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `bad_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Sman_badbothvsadl.pdf", replace


twoway ( kdensity hhmedcost if  manheal==2 & hhstatus!=3 & hhmedcost<40000,  lcolor(blue))  ( kdensity hhmedcost if  manhealadl==2 & hhstatus!=3 & hhmedcost<40000, lcolor(red)), legend(label(1 "Bad (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Sman_badvsadl.pdf", replace

twoway ( kdensity hhmedcost if  manheal==1 & hhstatus!=3 & hhmedcost<110000,  lcolor(blue))  ( kdensity hhmedcost if  manhealadl==2 & hhstatus!=3 & hhmedcost<110000, lcolor(red)), legend(label(1 "NH (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 50000 "Mean: `NH'", color(blue)) text(0.000075 50000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Sman_NHvsadl.pdf", replace



*couples
sum hhmedcost if  womanheal>1 & womanheal!=. & hhstatus==3, d
sum hhmedcost if  womanhealadl>1 & womanheal!=. & hhstatus==3, d

sum hhmedcost if  womanheal==1 & womanheal!=. & hhstatus==3, d
sum hhmedcost if  womanhealadl==1 & womanheal!=. & hhstatus==3, d


sum hhmedcost if  manheal>1 & manheal!=. & hhstatus==3, d
sum hhmedcost if  manhealadl>1 & manheal!=. & hhstatus==3, d

sum hhmedcost if  manheal==1 & manheal!=. & hhstatus==3, d
sum hhmedcost if  manhealadl==1 & manheal!=. & hhstatus==3, d

sum hhmedcost if  womanheal==2 & hhstatus==3

local bad=round(r(mean),10)

sum hhmedcost if  womanhealadl==2 & hhstatus==3

local adl_adl=round(r(mean),10)

sum hhmedcost if  womanhealadl==3 & hhstatus==3

local bad_adl=round(r(mean),10)

sum hhmedcost if  womanheal==1 & hhstatus==3

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  womanheal==2 & hhstatus==3 & hhmedcost<50000, lcolor(blue))  ( kdensity hhmedcost if  womanhealadl==3 & hhstatus==3 & hhmedcost<50000,  lcolor(red)), legend(label(1 "Bad (Base)") label(2 "Bad (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `bad_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cwoman_badbothvsadl.pdf", replace


twoway ( kdensity hhmedcost if  womanheal==2 & hhstatus==3 & hhmedcost<50000,  lcolor(blue))  ( kdensity hhmedcost if  womanhealadl==2 & hhstatus==3 & hhmedcost<50000,  lcolor(red)), legend(label(1 "Bad (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cwoman_badvsadl.pdf", replace

twoway ( kdensity hhmedcost if  womanheal==1 & hhstatus==3 & hhmedcost<110000,  lcolor(blue))  ( kdensity hhmedcost if  womanhealadl==2 & hhstatus==3 & hhmedcost<110000, lcolor(red)), legend(label(1 "NH (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 50000 "Mean: `NH'", color(blue)) text(0.000075 50000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cwoman_NHvsadl.pdf", replace

*men
sum hhmedcost if  manheal==2 & hhstatus==3

local bad=round(r(mean),10)

sum hhmedcost if  manhealadl==2 & hhstatus==3

local adl_adl=round(r(mean),10)

sum hhmedcost if  manhealadl==3 & hhstatus==3

local bad_adl=round(r(mean),10)


sum hhmedcost if  manheal==1 & hhstatus==3

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  manheal==2 & hhstatus==3 & hhmedcost<50000, lcolor(blue))  ( kdensity hhmedcost if  manhealadl==3 & hhstatus==3 & hhmedcost<50000, lcolor(red)), legend(label(1 "Bad (Base)") label(2 "Bad (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `bad_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cman_badbothvsadl.pdf", replace


twoway ( kdensity hhmedcost if  manheal==2 & hhstatus==3 & hhmedcost<50000,  lcolor(blue))  ( kdensity hhmedcost if  manhealadl==2 & hhstatus==3 & hhmedcost<50000, lcolor(red)), legend(label(1 "Bad (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cman_badvsadl.pdf", replace


twoway ( kdensity hhmedcost if  manheal==1 & hhstatus==3 & hhmedcost<110000,  lcolor(blue))  ( kdensity hhmedcost if  manhealadl==2 & hhstatus==3 & hhmedcost<110000, lcolor(red)), legend(label(1 "NH (Base)") label(2 "ADL (Alternate)") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.00009 50000 "Mean: `NH'", color(blue)) text(0.000075 50000 "Mean: `adl_adl'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "D:\Dropbox\hrs\wealthcouples\ADL\Cman_NHvsadl.pdf", replace



******************************************************
**** Changes to transition probabilities *************
******************************************************

tab lmanheal manheal, row nofreq
tab lmanhealadl manhealadl, row nofreq

tab lwomanheal womanheal, row nofreq
tab lwomanhealadl womanhealadl, row nofreq

*singles
tab lmanheal manheal if hhstatus!=3 & lmanhealadl!=. & manhealadl!=., row nofreq
tab lmanhealadl manhealadl if hhstatus!=3, row nofreq

tab lwomanheal womanheal if hhstatus!=3 & lwomanhealadl!=. & womanhealadl!=., row nofreq
tab lwomanhealadl womanhealadl if hhstatus!=3, row nofreq

*couples
xtset HHID wave
gen lhhstatus=L.hhstatus
tab lmanheal manheal if lhhstatus==3 & lmanhealadl!=. & manhealadl!=., row nofreq
tab lmanhealadl manhealadl if lhhstatus==3, row nofreq

tab lwomanheal womanheal if lhhstatus==3 & lwomanhealadl!=. & womanhealadl!=., row nofreq
tab lwomanhealadl womanhealadl if lhhstatus==3, row nofreq



******************************************************
***** Distributions for Referee 4 ********************
******************************************************



*singles

sum hhmedcost if (womanheal==3|manheal==3) & hhstatus!=3, d


sum hhmedcost if (womanheal==3|manheal==3) & hhstatus!=3

local good=round(r(mean),10)


sum hhmedcost if  (womanheal==2|manheal==2) & hhstatus!=3.

local bad=round(r(mean),10)



sum hhmedcost if (womanheal==1|manheal==1) & hhstatus!=3, d

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  (womanheal==3|manheal==3) & hhstatus!=3 &  hhmedcost<110000, lcolor(green) lpattern(--))  ( kdensity hhmedcost if  (womanheal==2|manheal==2) & hhstatus!=3 &  hhmedcost<110000,  lcolor(blue) lpattern(_)) ( kdensity hhmedcost if  (womanheal==1|manheal==1) & hhstatus!=3 &  hhmedcost<110000,  lcolor(red) lpattern(l)), legend(label(1 "Good") label(2 "Bad") label(3 "NH") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.000105 25000 "Mean: `good'", color(green)) text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `NH'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "c:\Dropbox\hrs\wealthcouples\ADL\SingDist.pdf", replace




*couples

sum hhmedcost if (womanheal==3 & manheal==3) & hhstatus==3

local good=round(r(mean),10)


sum hhmedcost if  (womanheal==2 & manheal!=1|manheal==2  & womanheal!=1) & hhstatus==3

local bad=round(r(mean),10)



sum hhmedcost if (womanheal==1 | manheal==1) & hhstatus==3

local NH=round(r(mean),10)

twoway ( kdensity hhmedcost if  (womanheal==3 & manheal==3) & hhstatus==3 &  hhmedcost<110000, lcolor(green) lpattern(--))  ( kdensity hhmedcost if  (womanheal==2 & manheal!=1|manheal==2  & womanheal!=1)  & hhstatus==3 &  hhmedcost<110000,  lcolor(blue) lpattern(_)) ( kdensity hhmedcost if  (womanheal==1|manheal==1) & hhstatus==3 &  hhmedcost<110000,  lcolor(red) lpattern(l)), legend(label(1 "Good") label(2 "Bad") label(3 "NH") position(2) ring(0)) xtitle("Medical Expenses") ytitle("Density") text(0.000105 25000 "Mean: `good'", color(green)) text(0.00009 25000 "Mean: `bad'", color(blue)) text(0.000075 25000 "Mean: `NH'", color(red)) ylabel(0(0.00005)0.0002, gmax gmin)
gr export "C:\Dropbox\hrs\wealthcouples\ADL\CoupleDist.pdf", replace

drop _all
log close